/**HEADER********************************************************************
* 
* Copyright (c) 2010 Linear Tech Corporation;
* All Rights Reserved
*
* Copyright (c) 2008 Freescale Semiconductor;
* All Rights Reserved
*
* Copyright (c) 1989-2008 ARC International;
* All Rights Reserved
*
*************************************************************************** 
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************
*
* $FileName: main.c$
* $Version : 3.5.26.0$
* $Version : Custom for LTC Board Demo Suite
* $Date    : Sep-10-2010$
*
* Comments:
*
*   The main function for this project, also Initializes the LTC Board.
*
*END************************************************************************/


//>>>>>>>>>>>>>>>>>>>>>>>>
//main.h
//main.c
//>>>>>>>>>>
//This file contains the MAIN task, which runs at the beginning to initialize everything.
//Later it goes into a loop and is responsible for running the HTTP server, effectively becoming the HTTP task.



#include <mqx.h>
#include <bsp.h>
#include <rtcs.h>

#include <ltctwrutils.h>  //All the utility functions for the LTC Tower board
#include <httpd.h>

#include <main.h>

#include <tfs.h>  //Trivial File System to host non-USB index page
#include <cgi.h>
#include <enet_wifi.h>  //Ethernet configuration
#include <config.h>  //Ethernet configuration

//#include <select.h>

#include <usb_task.h>  //Required for USB functionality

#include <logging.h>

#if BSPCFG_ENABLE_ADC
#include "adc.h"
#endif

#if ! BSPCFG_ENABLE_IO_SUBSYSTEM
#error This application requires BSPCFG_ENABLE_IO_SUBSYSTEM defined non-zero in user_config.h. Please recompile BSP with this option.
#endif


#ifndef BSP_DEFAULT_IO_CHANNEL_DEFINED
#error This application requires BSP_DEFAULT_IO_CHANNEL to be not NULL. Please set corresponding BSPCFG_ENABLE_TTYx to non-zero in user_config.h and recompile BSP with this option.
#endif


#if ! MQX_USE_TIMER
#error This application requires MQX_USE_TIMER defined non-zero in user_config.h. Please recompile BSP with this option.
#endif


#ifndef MQX_DEVICE
#define MQX_DEVICE BSP_DEFAULT_IO_CHANNEL
#endif



HTTPSRV_ALIAS http_aliases[] = {
    {"/usb/", "c:\\"},
    {NULL, NULL}
    };



LWGPIO_STRUCT led1;
LWGPIO_STRUCT led2;
LWGPIO_STRUCT led3;
LWGPIO_STRUCT led4;


/*TASK*-----------------------------------------------------------------
*
* Function Name  : main_task
* Returned Value : void
* Comments       : This runs to configure the Demo Suite and
* 					also maintains the HTTP server
*
*END------------------------------------------------------------------*/
void Main_task(uint_32 temp) {
    int_32            error;
    _enet_handle      ehandle;
    _rtcs_if_handle   ihandle;
    _enet_address     address;
//    HTTPD_STRUCT *server;
    extern const HTTPD_CGI_LINK_STRUCT cgi_lnk_tbl[];
    extern const HTTPD_FN_LINK_STRUCT fn_lnk_tbl[];  //Gotta add the fn_lnk_tbl for the callback function
    extern const TFS_DIR_ENTRY tfs_data[];
//    HTTPD_PARAMS_STRUCT *params;
uint_32                              i = 0;
uint_8 n_servers = 1;
#define HTTP_INET_AF    AF_INET
 char*                                indexes[BSP_ENET_DEVICE_COUNT];
  HTTPSRV_PARAM_STRUCT                 params1[BSP_ENET_DEVICE_COUNT];
   uint_32                              ip_addr[BSP_ENET_DEVICE_COUNT];
   uint_32                              server1[BSP_ENET_DEVICE_COUNT];



#ifdef BSP_LED1
/*******************************************************************************
Opening the pin (BSP_LED1) for output, drive the output level
*******************************************************************************/
    if (!lwgpio_init(&led1, BSP_LED1, LWGPIO_DIR_OUTPUT, LWGPIO_VALUE_NOCHANGE))
    {
        printf("Initializing LED1 GPIO as output failed.\n");
        _task_block();
    }
    /* swich pin functionality (MUX) to GPIO mode */
    lwgpio_set_functionality(&led1, BSP_LED1_MUX_GPIO);

    /* write logical 1 to the pin */
    lwgpio_set_value(&led1, LWGPIO_VALUE_LOW); /* set pin to 1 */

#endif
    
#ifdef BSP_LED2
/*******************************************************************************
Opening the pin (BSP_LED2) for output, drive the output level
*******************************************************************************/
    if (!lwgpio_init(&led2, BSP_LED2, LWGPIO_DIR_OUTPUT, LWGPIO_VALUE_NOCHANGE))
    {
        printf("Initializing LED2 GPIO as output failed.\n");
        _task_block();
    }
    /* swich pin functionality (MUX) to GPIO mode */
    lwgpio_set_functionality(&led2, BSP_LED1_MUX_GPIO);

    /* write logical 1 to the pin */
    lwgpio_set_value(&led2, LWGPIO_VALUE_LOW); /* set pin to 1 */

#endif
    
#ifdef BSP_LED3
/*******************************************************************************
Opening the pin (BSP_LED3) for output, drive the output level
*******************************************************************************/
    if (!lwgpio_init(&led3, BSP_LED3, LWGPIO_DIR_OUTPUT, LWGPIO_VALUE_NOCHANGE))
    {
        printf("Initializing LED3 GPIO as output failed.\n");
        _task_block();
    }
    /* swich pin functionality (MUX) to GPIO mode */
    lwgpio_set_functionality(&led3, BSP_LED1_MUX_GPIO);

    /* write logical 1 to the pin */
    lwgpio_set_value(&led3, LWGPIO_VALUE_LOW); /* set pin to 1 */

#endif
    
#ifdef BSP_LED4
/*******************************************************************************
Opening the pin (BSP_LED4) for output, drive the output level
*******************************************************************************/
    if (!lwgpio_init(&led4, BSP_LED4, LWGPIO_DIR_OUTPUT, LWGPIO_VALUE_NOCHANGE))
    {
        printf("Initializing LED4 GPIO as output failed.\n");
        _task_block();
    }
    /* swich pin functionality (MUX) to GPIO mode */
    lwgpio_set_functionality(&led4, BSP_LED1_MUX_GPIO);

    /* write logical 1 to the pin */
    lwgpio_set_value(&led4, LWGPIO_VALUE_LOW); /* set pin to 1 */

#endif


    _time_delay (2000);


    /* runtime RTCS configuration (we have more than 32kB)*/
    _RTCSPCB_init = 4;
    _RTCSPCB_grow = 2;
    _RTCSPCB_max = 6;
    _RTCS_msgpool_init = 4;
    _RTCS_msgpool_grow = 2;
    _RTCS_msgpool_max  = 8;
    _RTCS_socket_part_init = 4;
    _RTCS_socket_part_grow = 2;
    _RTCS_socket_part_max  = 6;
   
    
    _RTCSTASK_stacksize = 2200;

    error = RTCS_create();
    
    
    if (error) {
      printf("\nFailed to create RTCS, error = %X", error);
      return;
    }

    ENET_get_mac_address(DEMOCFG_DEFAULT_DEVICE, ENET_IPADDR, address);
    error = ENET_initialize(DEMOCFG_DEFAULT_DEVICE, address, 0, &ehandle);
    
    if (error) {
      printf("\nFailed to initialize Ethernet driver: %s",
      ENET_strerror(error));
      return;
    }
        
    error = RTCS_if_add(ehandle, RTCS_IF_ENET, &ihandle);
    
    if (error) {
      printf("\nFailed to add interface for Ethernet, error = %x", error);
      return;
    }
    
    error = RTCS_if_bind(ihandle, ENET_IPADDR, ENET_IPMASK);
    if (error) {
      printf("\nFailed to bind interface for Ethernet, error = %x", error);
      return;
    }

    printf("\nEthernet device %d bound to %X", DEMOCFG_DEFAULT_DEVICE, ENET_IPADDR);    
    
    //Initialize the Tower (populate the struct)
    printf("Initializing Parameters...\n");
    LTCTWR_InitializeParameters();
        
    error = _io_tfs_install("tfs:", tfs_data);
    
    /* Start HTTP server on each interface */
    for (i = 0; i < n_servers; i++)
    {
        _mem_zero(&params1[i], sizeof(HTTPSRV_PARAM_STRUCT));
        params1[i].af = HTTP_INET_AF;  //IPv4, IPv6 or from config.h

        #if RTCSCFG_ENABLE_IP6
        /* Set interface number here. Zero is any. */
        params1[i].ipv6_scope_id = HTTP_SCOPE_ID;
        #endif
        indexes[i] = (char*) _mem_alloc_zero(sizeof("\\index_x.html"));
        sprintf(indexes[i], "\\index.html", i);
        params1[i].root_dir = "tfs:";
        params1[i].alias_tbl = (HTTPSRV_ALIAS*)http_aliases;
        params1[i].index_page = indexes[i];
 //       params1[i].auth_table = auth_realms;
        printf("Starting http server No.%d on IP", i);
        /*
        ** If there is only one server listen on any IP address 
        ** so address can change in runtime (DHCP etc.).
        ** Otherwise we will use static IP for server.
        */
        if (HTTP_INET_AF & AF_INET)
        {
            #if RTCSCFG_ENABLE_IP4
            if ((i == 0) && (n_servers == 1))
            {
                params1[i].ipv4_address.s_addr = INADDR_ANY;
            }
            else
            {
                params1[i].ipv4_address.s_addr = ip_addr[i];
            }
            /* Print active IPv4 address */
            printf(" %d.%d.%d.%d", IPBYTES(ip_addr[i]));
            #endif
        }
        if (HTTP_INET_AF & AF_INET6)
        {
            #if RTCSCFG_ENABLE_IP6 
            IPCFG6_GET_ADDR_DATA data;
            char prn_addr6[sizeof("ffff:ffff:ffff:ffff:ffff:ffff:255.255.255.255")];
            
            ipcfg6_get_addr_info_n(0, 0, &data);

            if(inet_ntop(AF_INET6, &(data.ip_addr), prn_addr6, sizeof(prn_addr6)))
            {
                /* Print active IPv6 address */
                printf("%s %s", (HTTP_INET_AF & AF_INET) ? " and" : "", prn_addr6);
            }
            #endif
        }
        /*
        ** Maximum default number of available sockets in RTCS is six.
        ** Maximum of two are used for HTTP server as listening sockets (one for IPv4 and one for IPv6).
        ** So we take two of sockets and use them for sessions.
        */
        params1[i].max_ses = 2;
        params1[i].cgi_lnk_tbl = (HTTPSRV_CGI_LINK_STRUCT*) cgi_lnk_tbl;
        params1[i].ssi_lnk_tbl = (HTTPSRV_SSI_LINK_STRUCT*)fn_lnk_tbl;

        /* There are a lot of static data in CGIs so we have to set large enough stack for script handler */
        params1[i].script_stack = 2000;
        server1[i] = HTTPSRV_init(&params1[i]);
        
        printf("...");
        if (server1[i] == RTCS_ERROR)
        {
            printf("[FAIL]\n");
        }
        else
        {
            printf("[OK]\n");
        }
    }
  
#if HTTPD_SEPARATE_TASK || !HTTPDCFG_POLL_MODE    

    _task_block();


#else    
    while (1) {
        httpd_server_poll(server, 1);
        
        /* user stuff come here - only non blocking calls */
    }
#endif
}


